﻿
Imports QCAP.NET

Public Class MyShareRecordingDlg

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_pSetupForm As MySetupControl

    Public m_hCapDev() As UInt32 = {0, 0, 0, 0}

    Public m_strCurrentDir As String = ""

    Public m_bSupportGPU As Boolean = False

    Public m_bIsShareRecord As Boolean = False

    Public m_bCheckedAVI As Boolean = False

    Public m_bCheckedMP4 As Boolean = True

    Public m_bShareRecordCH() As Boolean = {True, False, False, False}

    Public m_strAviName As String = ""

    Private Sub MyShareRecordingDlg_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' GET CURRENT DIRECTORY
        '
        m_strCurrentDir = System.IO.Directory.GetCurrentDirectory()

        m_strAviName = m_strCurrentDir + "\\SHARE_RECORD.MP4"

        textBoxRecordAVI1_1.Text = m_strAviName

        m_btnShareRecordStart1.Enabled = True : m_btnShareRecordStop1.Enabled = False

        m_btnShareSwitchCH01.Checked = True : m_btnShareSwitchCH02.Checked = False : m_btnShareSwitchCH03.Checked = False : m_btnShareSwitchCH04.Checked = False

        m_bShareRecordCH(0) = True : m_bShareRecordCH(1) = False : m_bShareRecordCH(2) = False : m_bShareRecordCH(3) = False

    End Sub

    Private Sub MyShareRecordingDlg_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub buttonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonOK.Click

        m_btnShareRecordStop1_Click(sender, e)

        Hide()

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        m_hCapDev(0) = m_pSetupForm.m_hCapDev1

        m_hCapDev(1) = m_pSetupForm.m_hCapDev2

        m_hCapDev(2) = m_pSetupForm.m_hCapDev3

        m_hCapDev(3) = m_pSetupForm.m_hCapDev4

    End Sub

    Private Sub m_btnShareRecordStart1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareRecordStart1.Click

        m_btnShareRecordStart1.Enabled = False

        m_btnShareRecordStop1.Enabled = True

        m_bSupportGPU = m_checkGPU1_1.Checked

        Dim nVideoWidth As UInt32 = m_pSetupForm.m_pMainForm.m_nVideoWidth

        Dim nVideoHeight As UInt32 = m_pSetupForm.m_pMainForm.m_nVideoHeight

        Dim dVideoFrameRate As Double = m_pSetupForm.m_pMainForm.m_dVideoFrameRate

        If m_bCheckedAVI = True Then

            EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000)

        End If

        If m_bCheckedMP4 = True Then

            EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000)

        End If

        If m_bSupportGPU = True Then

            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32595559, nVideoWidth, nVideoHeight, dVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4194304, 30, 0, 0, ShareWindow.Handle.ToInt32(), 1)

        Else

            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32595559, nVideoWidth, nVideoHeight, dVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4194304, 30, 0, 0, ShareWindow.Handle.ToInt32(), 1)

        End If

        EXPORTS.QCAP_START_SHARE_RECORD(0, m_strAviName)

        m_bIsShareRecord = True

        m_pSetupForm.m_pMainForm.m_bIsShareRecord = True

    End Sub

    Private Sub m_btnShareRecordStop1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareRecordStop1.Click

        m_btnShareRecordStart1.Enabled = True

        m_btnShareRecordStop1.Enabled = False

        EXPORTS.QCAP_STOP_SHARE_RECORD(0)

        m_bIsShareRecord = False

        m_pSetupForm.m_pMainForm.m_bIsShareRecord = False

    End Sub

    Private Sub m_checkGPU1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkGPU1_1.Click

        m_btnShareRecordStop1_Click(sender, e)

    End Sub

    Private Sub m_checkAVI1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI1_1.Click

        m_checkAVI1_1.Checked = True

        m_checkMP41_1.Checked = False

        m_bCheckedAVI = True

        m_bCheckedMP4 = False

        m_strAviName = m_strAviName.Replace(".MP4", ".AVI")

        textBoxRecordAVI1_1.Text = m_strAviName

    End Sub

    Private Sub m_checkMP41_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP41_1.Click

        m_checkAVI1_1.Checked = False

        m_checkMP41_1.Checked = True

        m_bCheckedAVI = False

        m_bCheckedMP4 = True

        m_strAviName = m_strAviName.Replace(".AVI", ".MP4")

        textBoxRecordAVI1_1.Text = m_strAviName

    End Sub


    Private Sub m_btnShareSwitchCH01_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareSwitchCH01.Click

        m_btnShareSwitchCH01.Checked = True

        m_btnShareSwitchCH02.Checked = False

        m_btnShareSwitchCH03.Checked = False

        m_btnShareSwitchCH04.Checked = False

        m_bShareRecordCH(0) = True : m_bShareRecordCH(1) = False : m_bShareRecordCH(2) = False : m_bShareRecordCH(3) = False

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(0) = m_bShareRecordCH(0)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(1) = m_bShareRecordCH(1)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(2) = m_bShareRecordCH(2)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(3) = m_bShareRecordCH(3)

    End Sub

    Private Sub m_btnShareSwitchCH02_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareSwitchCH02.Click

        m_btnShareSwitchCH01.Checked = False

        m_btnShareSwitchCH02.Checked = True

        m_btnShareSwitchCH03.Checked = False

        m_btnShareSwitchCH04.Checked = False

        m_bShareRecordCH(0) = False : m_bShareRecordCH(1) = True : m_bShareRecordCH(2) = False : m_bShareRecordCH(3) = False

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(0) = m_bShareRecordCH(0)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(1) = m_bShareRecordCH(1)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(2) = m_bShareRecordCH(2)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(3) = m_bShareRecordCH(3)

    End Sub

    Private Sub m_btnShareSwitchCH03_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareSwitchCH03.Click

        m_btnShareSwitchCH01.Checked = False

        m_btnShareSwitchCH02.Checked = False

        m_btnShareSwitchCH03.Checked = True

        m_btnShareSwitchCH04.Checked = False

        m_bShareRecordCH(0) = False : m_bShareRecordCH(1) = False : m_bShareRecordCH(2) = True : m_bShareRecordCH(3) = False

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(0) = m_bShareRecordCH(0)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(1) = m_bShareRecordCH(1)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(2) = m_bShareRecordCH(2)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(3) = m_bShareRecordCH(3)

    End Sub

    Private Sub m_btnShareSwitchCH04_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareSwitchCH04.Click

        m_btnShareSwitchCH01.Checked = False

        m_btnShareSwitchCH02.Checked = False

        m_btnShareSwitchCH03.Checked = False

        m_btnShareSwitchCH04.Checked = True

        m_bShareRecordCH(0) = False : m_bShareRecordCH(1) = False : m_bShareRecordCH(2) = False : m_bShareRecordCH(3) = True

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(0) = m_bShareRecordCH(0)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(1) = m_bShareRecordCH(1)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(2) = m_bShareRecordCH(2)

        m_pSetupForm.m_pMainForm.m_bShareRecordCH(3) = m_bShareRecordCH(3)

    End Sub


End Class